﻿//document.addEventListener("DOMContentLoaded", startGame, false);

function startGame() {
    if (BABYLON.Engine.isSupported()) {
        var canvas = document.getElementById("renderCanvas");
        var engine = new BABYLON.Engine(canvas, true);

        var scene;
        var currentCameraType = 0;
        var currentRenderingType = 0;
        var currentAAType = 0;
        var currentScalingLevel = 1;
        var automaticHardwareScaling = true;
        var currentFPS;

        window.addEventListener("resize", onResize, false);

        // Displayed while loading the scene
        var workInProgressElement = document.getElementsByClassName("workInProgress")[0];
        var fpsCounter = document.getElementById("fpsCounter");

        BABYLON.SceneLoader.Load("Spaceship/", "Spaceship.babylon", engine, function (newScene) {
            GameManager.gameStarted = true;
            // Wait for textures and shaders to be ready
            newScene.executeWhenReady(function () {
                scene = newScene;
                // Attach camera to canvas inputs
                newScene.activeCamera.attachControl(canvas);

                //SwitchCamera
                switchCamera(0);

                WinJS.Utilities.addClass(workInProgressElement, "hidden");
                restartEngine();
            });
        }, function (progress) {
            // To do: give progress feedback to user
        });

        function onResize() {
            canvas.width = canvas.clientWidth;
            engine.setHardwareScalingLevel(currentScalingLevel);
        };

        var switchAA = function (AAType) {
            switch (currentAAType) {
                case 1:
                    scene.activeCamera.__fxaa_cookie.dispose(),
                    scene.activeCamera.__fxaa_cookie = null;
                    break;
                case 2:
                    scene.activeCamera.__fsaa_cookie.dispose(),
                    scene.activeCamera.__fsaa_cookie = null;
                    break;
            }

            switch (AAType) {
                case 1:
                    scene.activeCamera.__fxaa_cookie = new BABYLON.FxaaPostProcess("fxaa", 1.0, scene.activeCamera);
                    break;
                case 2:
                    var fx = new BABYLON.PassPostProcess("fsaa", 2.0, scene.activeCamera);
                    fx.renderTargetSamplingMode = BABYLON.Texture.BILINEAR_SAMPLINGMODE;
                    scene.activeCamera.__fsaa_cookie = fx;
                    break;
            }

            currentAAType = AAType;
        };

        var switchHardwareScaling = function (scalingLevel) {
            switch (scalingLevel) {
                case 0:
                    automaticHardwareScaling = true;
                    currentScalingLevel = 1;
                    engine.setHardwareScalingLevel(1);
                    break;
                case 1:
                case 2:
                case 4:
                    currentScalingLevel = scalingLevel;
                    automaticHardwareScaling = false;
                    engine.setHardwareScalingLevel(scalingLevel);
                    break;
            }
        };

        // Called from settingFlyout.html 
        var switchCamera = function (cameraType) {
            if (!scene) {
                return;
            }

            var camera;
            currentCameraType = cameraType;

            switch (cameraType) {
                case 0:
                    // Called from the setting flyout to control the camera with keyboard & mouse
                    //camera = new BABYLON.FreeCamera("freeCamera", scene.activeCamera.position, scene);
                    camera = new BABYLON.ArcRotateCamera("freeCamera", 0, Math.PI / 2, 5000, BABYLON.Vector3.Zero(), scene);
                    break;
                case 1:
                    // Called from the setting flyout to control the camera with touch
                    camera = new BABYLON.TouchCamera("touchCamera", scene.activeCamera.position, scene);
                    break;
                case 2:
                    // Called from the setting flyout to control the camera with the sensors of the device
                    camera = new BABYLON.DeviceOrientationCamera("deviceOrientationCamera", scene.activeCamera.position, scene);
                    break;
            }

            if (scene.activeCamera.rotation) {
                camera.rotation = scene.activeCamera.rotation.clone();
            }
            camera.fov = scene.activeCamera.fov;
            camera.minZ = scene.activeCamera.minZ;
            camera.maxZ = scene.activeCamera.maxZ;

            if (scene.activeCamera.ellipsoid) {
                camera.ellipsoid = scene.activeCamera.ellipsoid.clone();
            }
            camera.checkCollisions = scene.activeCamera.checkCollisions;
            camera.applyGravity = scene.activeCamera.applyGravity;

            camera.speed = scene.activeCamera.speed;

            camera.postProcesses = scene.activeCamera.postProcesses;
            scene.activeCamera.postProcesses = [];
            scene.activeCamera.detachControl(canvas);

            scene.activeCamera = camera;

            scene.activeCamera.attachControl(canvas);
        };

        // Called from the setting flyout to set back the rendering to full color
        var switchToNormalRendering = function () {
            cleanPostProcesses();
            currentRenderingType = 0;
        };

        // Called from the setting flyout to set the rendering into B&W
        var switchToBWRendering = function () {
            cleanPostProcesses();
            scene.activeCamera.__bandw_cookie = new BABYLON.BlackAndWhitePostProcess("bandw", 1.0, scene.activeCamera);
            currentRenderingType = 1;
        };

        // Called from the setting flyout to set the rendering into Sepia
        var switchToSepiaRendering = function () {
            cleanPostProcesses();
            var sepiaKernelMatrix = BABYLON.Matrix.FromValues(
                0.393, 0.349, 0.272, 0,
                0.769, 0.686, 0.534, 0,
                0.189, 0.168, 0.131, 0,
                0, 0, 0, 0
            );
            scene.activeCamera.__sepia_cookie = new BABYLON.ConvolutionPostProcess("Sepia", sepiaKernelMatrix, 1.0, scene.activeCamera);
            currentRenderingType = 2;
        };

        var cleanPostProcesses = function () {
            if (scene && scene.activeCamera) {
                if (scene.activeCamera.__bandw_cookie) {
                    scene.activeCamera.__bandw_cookie.dispose(),
                    scene.activeCamera.__bandw_cookie = null;
                }
                if (scene.activeCamera.__sepia_cookie) {
                    scene.activeCamera.__sepia_cookie.dispose(),
                    scene.activeCamera.__sepia_cookie = null;
                }
            }
        };

        // Called by settings panel to populate the current values of the settings
        var getSettings = function () {
            for (var i = 0; i < settingCameraType.length; i++) {
                if (settingCameraType[i].value === "" + currentCameraType) {
                    settingCameraType[i].checked = true;
                }
            }
            for (var i = 0; i < renderingType.length; i++) {
                if (renderingType[i].value === "" + currentRenderingType) {
                    renderingType[i].checked = true;
                }
            }
            for (var i = 0; i < AAType.length; i++) {
                if (AAType[i].value === "" + currentAAType) {
                    AAType[i].checked = true;
                }
            }
            if (automaticHardwareScaling) {
                hardwareScalingType[0].checked = true;
            }
            else {
                for (var i = 1; i < hardwareScalingType.length; i++) {
                    if (hardwareScalingType[i].value === "" + currentScalingLevel) {
                        hardwareScalingType[i].checked = true;
                    }
                }
            }
        };

        var suspendEngine = function () {
            engine.stopRenderLoop();
        };

        var restartEngine = function () {
            // Once the scene is loaded, just register a render loop to render it
            engine.runRenderLoop(function () {
                currentFPS = BABYLON.Tools.GetFps().toFixed();
                fpsCounter.innerText = currentFPS + " fps";
                if (automaticHardwareScaling && currentScalingLevel < 5 && currentFPS < 7) {
                    currentScalingLevel++;
                    engine.setHardwareScalingLevel(currentScalingLevel);
                }
                if (automaticHardwareScaling && currentScalingLevel > 1 && currentFPS > 15) {
                    currentScalingLevel--;
                    engine.setHardwareScalingLevel(currentScalingLevel);
                }
                scene.render();
            });
        };

        // Using WinJS Namespace to expose public logic
        WinJS.Namespace.define("GameManager", {
            switchCamera: switchCamera,
            switchToNormalRendering: switchToNormalRendering,
            switchToBWRendering: switchToBWRendering,
            switchToSepiaRendering: switchToSepiaRendering,
            switchAA: switchAA,
            switchHardwareScaling: switchHardwareScaling,
            getSettings: getSettings,
            suspendEngine: suspendEngine,
            restartEngine: restartEngine
        });
    }
}