/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashMap;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.StringHelper;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class DuplicatedString
extends IteratingRule {
    private FieldAccess fldValue;
    private HashMap<String, Integer> map = new HashMap();
    private Histogram<Histogram.Entry> dupSources = new Histogram();
    private StringHelper helper;
    private int total;

    public DuplicatedString() {
        super(NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_Name"), NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_Desc"), "java.lang.String");
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_LongDesc");
    }

    @Override
    protected void perform(Instance instance) {
        String string = this.helper.decodeString(instance);
        Integer n = this.map.get(string);
        if (n != null) {
            int n2 = instance.getSize();
            Instance instance2 = this.fldValue.getRefValue(instance);
            if (instance2 != null) {
                n2 += string.length() * 2 + 14;
            }
            String string2 = this.getContext().getRootIncommingString(instance);
            string2 = Utils.printClass(this.getContext(), string2);
            this.dupSources.add(string2, new Histogram.Entry(n2));
            this.total += n2;
        }
        n = n == null ? 1 : n + 1;
        this.map.put(string, n);
    }

    @Override
    protected void prepareRule(MemoryLint memoryLint) {
        Heap heap = memoryLint.getHeap();
        this.helper = memoryLint.getStringHelper();
        JavaClass javaClass = heap.getJavaClassByName("java.lang.String");
        this.fldValue = new FieldAccess(javaClass, "value");
    }

    @Override
    protected void summary() {
        this.getContext().appendResults(NbBundle.getMessage(DuplicatedString.class, (String)"FMT_DupStr_Result", (Object)this.total));
        this.getContext().appendResults(this.dupSources.toString(50000));
    }
}

