import { __awaiter } from "tslib";
import { DageUploadType } from "./types";
/**
 * 可选文件类型
 */
export const ACCEPT = {
    [DageUploadType.IMG]: ".jpg,.jpeg,.png,.gif",
    [DageUploadType.MOBILE_MODEL]: ".zip",
    [DageUploadType.MODEL]: ".4dage",
    [DageUploadType.VIDEO]: ".mp4",
    [DageUploadType.AUDIO]: ".mp3",
};
/**
 * 校验文件类型
 */
export const validateFileType = (file, accept) => {
    if (accept === "*")
        return true;
    const fileName = file.name.toLowerCase();
    const fileExtension = fileName.substring(fileName.lastIndexOf("."));
    return accept.split(",").includes(fileExtension);
};
export function getImageSize(file) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            const img = new Image();
            img.onload = () => {
                resolve({ width: img.width, height: img.height });
            };
            img.onerror = (err) => {
                reject(err);
            };
            img.src = URL.createObjectURL(file);
        });
    });
}
