import { jsx as _jsx } from "react/jsx-runtime";
import { createContext, useRef, useState } from 'react';
export const DageUploadContext = createContext(null);
export const DageUploadConsumer = DageUploadContext.Consumer;
export const DageUploadProvider = (props) => {
    /** 待上传文件数量 */
    const uploadingFileNum = useRef(0);
    const [uploading, setUploading] = useState(false);
    const handleUploadingFileNum = (type) => {
        if (type === 'add') {
            uploadingFileNum.current += 1;
            setUploading(true);
        }
        else {
            uploadingFileNum.current -= 1;
            if (uploading && !uploadingFileNum.current) {
                setUploading(false);
            }
        }
    };
    return (_jsx(DageUploadContext.Provider, { value: { uploading, handleUploadingFileNum }, children: props.children }));
};
