import { TreeProps } from "antd/es/tree";
export type DageTreeActionData = {
    id: number;
    name: string;
    hideAddBtn?: boolean;
    hideEditBtn?: boolean;
    hideDeleteBtn?: boolean;
    children: DageTreeActionData[];
};
export interface DageTreeActionsProps extends Omit<TreeProps, "titleRender" | "treeData" | "fieldNames"> {
    /**
     * 最大层级，从0开始
     */
    maxLevel?: number;
    treeData: DageTreeActionData[];
    onAdd?: (item: DageTreeActionData, path: number[]) => void;
    onEdit?: (item: DageTreeActionData, path: number[]) => void;
    onDelete?: (item: DageTreeActionData, path: number[]) => void;
}
export interface DageTreeTitleProps extends Pick<DageTreeActionsProps, "onAdd" | "onEdit" | "onDelete" | "maxLevel" | "treeData"> {
    data: DageTreeActionData;
}
//# sourceMappingURL=types.d.ts.map