import { Tree } from "antd";
import styled from "styled-components";
export const TreeActions = styled(Tree).attrs({
    className: "dage-tree-actions",
}) `
  --dage-tree-actions-title-height: 30px;

  .ant-tree-treenode {
    padding: 0;

    &.ant-tree-treenode-selected,
    &:hover {
      background: rgba(182, 227, 255, 0.3);
    }
    &:hover {
      .dage-tree-title-toolbar {
        display: block;
      }
    }
  }
  .ant-tree-node-content-wrapper {
    &.ant-tree-node-selected,
    &:hover {
      background: none;
    }
  }
  .ant-tree-switcher {
    line-height: var(--dage-tree-actions-title-height);
  }
  .ant-btn[color="default"] {
    color: inherit;
  }
`;
export const TreeTitle = styled.div.attrs({
    className: "dage-tree-title",
}) `
  display: flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  height: var(--dage-tree-actions-title-height);
  font-size: 12px;

  p {
    margin: 0;
    flex: 1;
    width: 0;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
  }
  .dage-tree-title-toolbar {
    display: none;
  }
`;
