import { config as AmapReactConfig } from "@amap/amap-react";
import { requestByGet } from "@dage/service";
AmapReactConfig.version = "2.0"; // 默认2.0，这里可以不修改
AmapReactConfig.key = "8de83e1728d5368f8452eee95f35585d";
// @ts-ignore
window._AMapSecurityConfig = {
    serviceHost: "https://sit-shgybwg.4dage.com/_AMapService",
};
/**
 * 修改高德地图 js-key
 * @param key JS-API key
 * @param serviceHost 安全密钥地址
 */
export const setAmapJSKey = (key, serviceHost) => {
    AmapReactConfig.key = key;
    if (serviceHost) {
        // @ts-ignore
        window._AMapSecurityConfig = {
            serviceHost,
        };
    }
};
/**
 * 提供根据用户输入的关键词查询返回建议列表
 * @link https://lbs.amap.com/api/webservice/guide/api/inputtips
 * @param value
 * @param city 搜索城市
 * @param citylimit 是否限制城市搜索 默认-true
 * @returns
 */
export const getAmapInputTips = (path, value, city, citylimit = "true") => {
    return requestByGet(path, {
        keywords: value,
        city,
        citylimit,
    });
};
