export interface DageMapMethods {
    mapRef: AMap.Map_2 | undefined;
}
export interface DageMapProps {
    /** 纬度 */
    latitude: number;
    /** 经度 */
    longitude: number;
    /** 地址 */
    address: string;
    /**
     * 是否禁用
     * @default false
     */
    disabled?: boolean;
    /**
     * 指定进行编码查询的城市，支持传入城市名、adcode 和 citycode
     */
    city?: string | number;
    /**
     * 仅限规定市区内范围搜索，city 值为 number 类型生效
     */
    onlyCityArea?: boolean;
    /**
     * 超出市区范围提示语，onlyCityArea 为 true 生效
     */
    outCityAreaMessage?: string;
    /**
     * 输入提示调用的接口地址
     */
    inputTipsApi: string;
    /**
     * 地址发生改变回调
     */
    onAddressChange?(val: string): void;
    /**
     * 经纬度发生改变回调
     */
    onLngLatChange?(e: DageMapLngLatChangeEvent): void;
    /**
     * 地图加载完成回调
     */
    onMapComplete?(): void;
    /**
     * 选择坐标超出市区范围或者解析不出地址回调
     */
    onError?(): void;
}
export type DageMapLngLatChangeEvent = {
    lng: number;
    lat: number;
};
export interface DageMapPoisType {
    adcode: string;
    address: string;
    location: string;
    name: string;
}
export interface AMapTipsResponse {
    tips: DageMapPoisType[];
}
export * from "./plugins/Geocoder/types";
//# sourceMappingURL=types.d.ts.map