import { __awaiter, __rest } from "tslib";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { message } from "antd";
import { Editor, Toolbar } from "@wangeditor/editor-for-react";
import { getBaseURL, requestByPost } from "@dage/service";
import { DageUploadType } from "../DageUpload";
import { ACCEPT, validateFileType } from "../DageUpload/utils";
import "@wangeditor/editor/dist/css/style.css";
import { DageLoading } from "../DageLoading";
import { LoadingOutlined } from "@ant-design/icons";
import { assign } from "lodash";
export const DageEditor = (_a) => {
    var { value, style, className, action, readOnly, fieldName = "file", maxImgSize = 2, maxVideoSize = 100, placeholder = "请输入内容", onChange, onCreated, onDestroyed, onFocus, onBlur, customPaste } = _a, tbConfig = __rest(_a, ["value", "style", "className", "action", "readOnly", "fieldName", "maxImgSize", "maxVideoSize", "placeholder", "onChange", "onCreated", "onDestroyed", "onFocus", "onBlur", "customPaste"]);
    const [uploadLoading, setUploadLoading] = useState(false);
    const [editor, setEditor] = useState(null);
    const validateFile = (file, type) => {
        if (!validateFileType(file, ACCEPT[type])) {
            message.error("选择的文件类型不正确！");
            return false;
        }
        const size = type === DageUploadType.IMG ? maxImgSize : maxVideoSize;
        // 校验文件大小
        const isLtM = file.size / 1024 / 1024 < size;
        if (!isLtM) {
            message.error(`最大支持 ${size}M!`);
            return false;
        }
        return true;
    };
    const uploadFile = (file, type) => __awaiter(void 0, void 0, void 0, function* () {
        const formData = new FormData();
        formData.append("type", type);
        if (file instanceof Blob) {
            formData.append(fieldName, file, file.name);
        }
        else {
            formData.append(fieldName, file);
        }
        const data = yield requestByPost(action, formData);
        return data;
    });
    // 工具栏配置
    const toolbarConfig = assign({
        excludeKeys: ["codeBlock", "group-video"],
    }, tbConfig);
    // 编辑器配置
    const editorConfig = {
        readOnly,
        placeholder,
        MENU_CONF: {
            uploadImage: {
                customUpload(file, insertFn) {
                    return __awaiter(this, void 0, void 0, function* () {
                        if (!validateFile(file, DageUploadType.IMG))
                            return;
                        try {
                            setUploadLoading(true);
                            const baseUrl = getBaseURL();
                            const data = yield uploadFile(file, DageUploadType.IMG);
                            insertFn(`${baseUrl}${data.filePath}`, data.fileName, data.filePath);
                        }
                        finally {
                            setUploadLoading(false);
                        }
                    });
                },
            },
            uploadVideo: {
                customUpload(file, insertFn) {
                    return __awaiter(this, void 0, void 0, function* () {
                        if (!validateFile(file, DageUploadType.VIDEO))
                            return;
                        try {
                            setUploadLoading(true);
                            const baseUrl = getBaseURL();
                            const data = yield uploadFile(file, DageUploadType.VIDEO);
                            insertFn(`${baseUrl}${data.filePath}`, data.fileName, data.filePath);
                        }
                        finally {
                            setUploadLoading(false);
                        }
                    });
                },
            },
        },
        onCreated,
        onDestroyed,
        onFocus,
        onBlur,
        customPaste,
    };
    useEffect(() => {
        return () => {
            if (editor == null)
                return;
            editor.destroy();
            setEditor(null);
        };
    }, [editor]);
    return (_jsxs("div", { className: className, style: Object.assign({ position: "relative", border: "1px solid var(--w-e-toolbar-border-color)" }, style), children: [_jsx(Toolbar, { editor: editor, defaultConfig: toolbarConfig, mode: "default", style: { borderBottom: "1px solid var(--w-e-toolbar-border-color)" } }), _jsx(Editor, { defaultConfig: editorConfig, value: value, onCreated: setEditor, onChange: (editor) => onChange === null || onChange === void 0 ? void 0 : onChange(editor.getHtml()), mode: "default", style: { height: "500px", overflowY: "hidden" } }), uploadLoading && (_jsx(DageLoading, { indicator: _jsx(LoadingOutlined, { style: { fontSize: 30 }, spin: true }) }))] }));
};
export * from "./types";
