import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { Input, Table } from "antd";
import { DageEditableRow } from "./EditableRow";
import { DageEditableCell } from "./EditableCell";
import { Editable } from "./style";
export const DageEditable = (_a) => {
    var { defaultColumns, handleSave } = _a, rest = __rest(_a, ["defaultColumns", "handleSave"]);
    const components = {
        body: {
            row: DageEditableRow,
            cell: DageEditableCell,
        },
    };
    const columns = defaultColumns.map((col) => {
        if (!col.editable) {
            return col;
        }
        return Object.assign(Object.assign({}, col), { onCell: (record) => ({
                record,
                editable: col.editable,
                dataIndex: col.dataIndex,
                title: col.title,
                Input: col.Input || _jsx(Input, {}),
                handleSave,
            }) });
    });
    return (_jsx(Editable, { children: _jsx(Table, Object.assign({}, rest, { columns: columns, rowClassName: () => "dage-editable-row", components: components })) }));
};
export * from "./context";
export * from "./types";
