const mapper = require("./dist/metadata.json");

/**
 * @type {{[key: string]: string}}
 */
const mapperCompiled = {};

for (const key in mapper) {
  mapper[key].forEach((i) => {
    mapperCompiled[i] = key;
  });
}

module.exports = {
  libraryName: "@dage/pc-components",
  camel2DashComponentName: false,
  customName: (name) => {
    if (name in mapperCompiled) {
      return `@dage/pc-components/dist/components/${mapperCompiled[name]}`;
    }
    return `@dage/pc-components/dist/noncomponents`;
  },
  transformToDefaultImport: false,
};
