import { ReactNode } from "react";
import { XMLMeta } from "./types";
/**
 * @see https://krpano.com/docu/actions
 */
type FuncName = "addplugin" | "removeplugin" | "set" | "loadxml" | "loadscene" | "loadpano" | "tween" | "addhotspot" | "removehotspot" | "includexml" | "includexmlstring" | "addlayer" | "removelayer" | "nexttick";
/**
 * 执行单个函数
 * @param func 函数名
 * @param params 参数列表
 */
export declare const buildKrpanoAction: (func: FuncName, ...params: Array<string | number | boolean>) => string;
/**
 * 动态添加标签用
 * @see https://krpano.com/forum/wbb/index.php?page=Thread&threadID=15873
 */
export declare const buildKrpanoTagSetterActions: (name: string, attrs: Record<string, string | boolean | number | undefined>) => string;
/**
 * 根据元数据构建xml
 */
export declare const buildXML: ({ tag, attrs, children }: XMLMeta) => string;
/**
 * 对Object进行map操作
 */
export declare const mapObject: (obj: Record<string, unknown>, mapper: (key: string, value: unknown) => Record<string, unknown>) => Record<string, unknown>;
/**
 * 主要用于绑定Krpano事件和js调用。提取某个对象中的onXXX属性并替换为对应的调用字符串，丢弃其他属性
 */
export declare const mapEventPropsToJSCall: (obj: Record<string, unknown>, getString: (key: string, value: unknown) => string) => Record<string, string>;
export declare const childrenToOuterHTML: (children: ReactNode) => string;
export declare const compareVersions: (version1: string, version2: string) => number;
export declare const is121Version: boolean;
export {};
//# sourceMappingURL=utils.d.ts.map