import { KrpanoActionProxy } from "./models";
declare global {
    interface Window {
        krpanoJS?: {
            version: string;
        };
        embedpano?: (config: IKrpanoConfig) => void;
        removepano?: (target: string) => void;
        /**
         * 开启 dev 模式，在拖动热点时会调用此事件
         */
        draggbleHotspotEvent?: (ath: number, atv: number) => void;
        ReactKrpanoActionProxy?: KrpanoActionProxy;
        onVideoSceneReady: () => void;
        onVideoScenePlay: () => void;
        onVideoScenePaused: () => void;
        onVideoSceneComplete: () => void;
        onVideoSceneError: (err: string) => void;
    }
    interface EventMapper {
        "Event.videoScene.ready": undefined;
        "Event.videoScene.play": undefined;
        "Event.videoScene.pause": undefined;
        "Event.videoScene.complete": undefined;
        "Event.videoScene.error": string;
    }
}
export interface NativeKrpanoRendererObject {
    buildversion: string;
    get(key: string): any;
    call(action: string): void;
}
/**
 * @see https://krpano.com/docu/html/#wmode
 */
export interface IKrpanoConfig {
    /**
     * 全景图xml路径。需要手动设置为null才不会加载。
     * @see https://krpano.com/docu/html/#xml
     */
    xml?: string | null;
    /**  挂载点id */
    target: string;
    swf?: string;
    id?: string;
    bgcolor?: string;
    /**
     * @see https://krpano.com/docu/html/#html5
     */
    html5?: string;
    flash?: string;
    wmode?: string;
    localfallback?: string;
    vars?: Record<string, unknown>;
    initvars?: Record<string, unknown>;
    consolelog?: boolean;
    basepath?: string;
    mwheel?: boolean;
    capturetouch?: boolean;
    focus?: boolean;
    webglsettings?: Record<string, unknown>;
    webxr?: string;
    mobilescale?: number;
    touchdevicemousesupport?: boolean;
    fakedevice?: string;
    passQueryParameters?: boolean;
    onready?: (renderer: NativeKrpanoRendererObject) => void;
}
export type EventCallback = (renderer: KrpanoActionProxy) => void;
export interface XMLMeta {
    tag: string;
    attrs: Record<string, string | number | boolean>;
    children?: XMLMeta[];
}
/**
 * 旋转方位
 */
export declare enum ROTATE_DIRECTION {
    UP = "up",
    DOWN = "down",
    LEFT = "left",
    RIGHT = "right"
}
/**
 * 缩放动作
 */
export declare enum ZOOM_ACTION {
    IN = "in",
    OUT = "out"
}
//# sourceMappingURL=types.d.ts.map