import { makeAutoObservable } from "mobx";
import { EventBus } from "@dage/utils";
export class VideoSceneModel {
    constructor() {
        this.event = new EventBus();
        /**
         * 播放中
         * @default true
         */
        this.playing = true;
        makeAutoObservable(this);
    }
    /** 播放 */
    play() {
        var _a;
        (_a = window.ReactKrpanoActionProxy) === null || _a === void 0 ? void 0 : _a.call("plugin[video].play()");
    }
    /** 暂停 */
    pause() {
        var _a;
        (_a = window.ReactKrpanoActionProxy) === null || _a === void 0 ? void 0 : _a.call("plugin[video].pause()");
    }
}
export const videoSceneModel = new VideoSceneModel();
window.onVideoSceneReady = () => {
    videoSceneModel.event.emit("Event.videoScene.ready", undefined);
};
window.onVideoScenePlay = () => {
    videoSceneModel.playing = true;
    videoSceneModel.event.emit("Event.videoScene.play", undefined);
};
window.onVideoScenePaused = () => {
    videoSceneModel.playing = false;
    videoSceneModel.event.emit("Event.videoScene.pause", undefined);
};
window.onVideoSceneComplete = () => {
    videoSceneModel.event.emit("Event.videoScene.complete", undefined);
};
window.onVideoSceneError = (error) => {
    videoSceneModel.event.emit("Event.videoScene.error", error);
};
