import { NativeKrpanoRendererObject } from "../types";
import { PromiseQueue } from "./PromiseQueue";
export declare class TagActionProxy {
    krpanoRenderer?: NativeKrpanoRendererObject;
    queue: PromiseQueue<unknown>;
    /**
     * 同步标签是否加载完成
     */
    syncTagsLoaded: boolean;
    syncTagStack: {
        tagName: string;
        attribute: Record<string, unknown>;
        children?: string;
    }[];
    syncXMLStringStack: string[];
    constructor(krpanoRenderer?: NativeKrpanoRendererObject);
    /**
     * 等待 include 标签加载完成
     */
    waitIncludeLoaded(push?: boolean): Promise<unknown>;
    /**
     * 将异步标签推入堆中
     */
    pushSyncTag(tagName: string, attribute: Record<string, unknown>, children?: string): void;
    /**
     * 创建一个插入同步标签后的 XMLDOM
     */
    createSyncTags(): Promise<Document>;
    private getXMLContent;
}
//# sourceMappingURL=TagActionProxy.d.ts.map