export class PromiseQueue {
    constructor() {
        this.queue = [];
        /**
         * 返回一个 promise 用于等待
         */
        this.push = () => {
            return new Promise((resolve, reject) => {
                this.queue.push({ resolve, reject });
            });
        };
        this.unshift = () => {
            return new Promise((resolve, reject) => {
                this.queue.unshift({ resolve, reject });
            });
        };
        /**
         * 清空队列, 正常结束
         */
        this.flushResolve = (value) => {
            this.queue.forEach((item) => item.resolve(value));
            this.queue = [];
        };
        /**
         * 清空队列, 移除结束
         */
        this.flushReject = (error) => {
            this.queue.forEach((item) => item.reject(error));
            this.queue = [];
        };
    }
}
