import { __awaiter } from "tslib";
import { PromiseQueue } from "./PromiseQueue";
export class DynamicTagActionProxy {
    constructor(krpanoRenderer) {
        this.queue = new PromiseQueue();
        /**
         * 同步标签是否加载完成
         */
        this.syncTagsLoaded = false;
        this.syncTagStack = [];
        this.krpanoRenderer = krpanoRenderer;
    }
    /**
     * 等待 include 标签加载完成
     */
    waitIncludeLoaded(push) {
        return this.syncTagsLoaded
            ? Promise.resolve()
            : // 先进后出
                this.queue[push ? "push" : "unshift"]();
    }
    /**
     * 将异步标签推入堆中
     */
    pushSyncTag(tagName, attribute) {
        this.syncTagStack.unshift({
            tagName,
            attribute,
        });
    }
    /**
     * 创建一个插入同步标签后的 XMLDOM
     */
    createSyncTags() {
        return __awaiter(this, void 0, void 0, function* () {
            const xmlDoc = yield this.getXMLContent();
            const krpanoElement = xmlDoc.querySelector("krpano");
            while (this.syncTagStack.length) {
                const tag = this.syncTagStack.pop();
                const element = xmlDoc.createElement(tag.tagName);
                for (const key in tag.attribute) {
                    element.setAttribute(key, tag.attribute[key]);
                }
                krpanoElement === null || krpanoElement === void 0 ? void 0 : krpanoElement.insertBefore(element, null);
            }
            return xmlDoc;
        });
    }
    getXMLContent() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            let contentText = "";
            const xml = (_a = this.krpanoRenderer) === null || _a === void 0 ? void 0 : _a.get("xml");
            const parser = new DOMParser();
            if (xml.content) {
                contentText = xml.content;
            }
            else if (xml.url) {
                contentText = yield fetch(xml.url).then((res) => res.text());
            }
            return parser.parseFromString(contentText, "text/xml");
        });
    }
}
