import { useEffect, useRef } from "react";
export function useUnMounted(cb) {
    const unmounted = useRef(false);
    useEffect(() => {
        return () => {
            if (!unmounted.current) {
                cb();
                unmounted.current = true;
            }
        };
    }, []);
}
