import { useLayoutEffect, useRef } from "react";
export function useEventCallback(callback) {
    const callbackRef = useRef(callback);
    useLayoutEffect(() => {
        callbackRef.current = callback;
    }, [callback]);
    return callbackRef;
}
