import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { memo, useContext, useEffect } from "react";
import { KrpanoRendererContext } from "../contexts";
export const View = memo((_a) => {
    var { children } = _a, viewAttrs = __rest(_a, ["children"]);
    const renderer = useContext(KrpanoRendererContext);
    useEffect(() => {
        if (!renderer)
            return;
        if (renderer.littlePlanetIntro) {
            renderer === null || renderer === void 0 ? void 0 : renderer.setTag("view", null, Object.assign({}, viewAttrs));
            // TOFIX: 如果开启小行星入场，会导致 limitview 设置失效
            setTimeout(() => {
                // 等待入场动画结束覆盖属性
                renderer === null || renderer === void 0 ? void 0 : renderer.setTag("view", null, Object.assign({}, viewAttrs));
            }, 4000);
        }
        else {
            renderer === null || renderer === void 0 ? void 0 : renderer.setTag("view", null, Object.assign({}, viewAttrs), true);
        }
    }, [renderer, viewAttrs]);
    return _jsx("div", { className: "view", children: children });
});
