import { jsx as _jsx } from "react/jsx-runtime";
import { useContext, useEffect } from "react";
import { observer } from "mobx-react";
import { KrpanoRendererContext } from "../contexts";
import { videoSceneModel } from "../models";
const DEFAULT_PLUGIN_ATTRS = {
    loop: true,
    volume: 0,
};
export const VideoScene = observer(({ name, videointerfaceXmlUrl, videoplayerUrl, sourceList, playRes, pluginAttrs, children, onVisibility, }) => {
    const renderer = useContext(KrpanoRendererContext);
    const model = videoSceneModel;
    const getSourceListStr = () => {
        let str = "";
        sourceList.forEach((item) => {
            str += `videointerface_addsource('${item.res}', '${item.url}', '${item.poster}');`;
        });
        return str;
    };
    const objectToString = (obj) => {
        let stack = [];
        Object.keys(obj).forEach((key) => {
            stack.push(`${key}="${obj[key]}"`);
        });
        return stack.join(" ");
    };
    const visibilityHandler = () => {
        if (document.visibilityState === "hidden") {
            model.pause();
        }
        onVisibility === null || onVisibility === void 0 ? void 0 : onVisibility();
    };
    useEffect(() => {
        window.addEventListener("visibilitychange", visibilityHandler);
        return () => {
            window.removeEventListener("visibilitychange", visibilityHandler);
        };
    }, []);
    useEffect(() => {
        if (!renderer)
            return;
        const _pluginAttrs = objectToString(Object.assign({}, DEFAULT_PLUGIN_ATTRS, pluginAttrs, {
            pausedonstart: !model.playing,
        }));
        renderer.tagAction.pushSyncTag("scene", {
            name,
        }, `
          <!-- include the videoplayer interface / skin -->
          <include url="${videointerfaceXmlUrl}" />

          <!-- include the videoplayer plugin -->
          <plugin ${_pluginAttrs} name="video"
            url="${videoplayerUrl}"
            onloaded="add_video_sources();"
          />

          <!-- use the videoplayer plugin as panoramic image source -->
          <image>
            <sphere url="plugin:video" />
          </image>

          <action name="add_video_sources" >
            ${getSourceListStr()}

            videointerface_play('${playRes}');
          </action>
        `);
    }, [renderer]);
    return _jsx("div", { className: "video-scene", children: children });
});
