import { FC } from "react";
export interface VideoSceneProps {
    name: string;
    videointerfaceXmlUrl: string;
    videoplayerUrl: string;
    /**
     * 视频源列表
     * @example
     * [{
     *   // 分辨率
     *   res: '1920x960',
     *   // | 分割视频文件 url，krpano会自动根据浏览器的兼容性选择合适的视频格式播放
     *   url: '/path/video-1920x960.mp4|/path/video-1920x960.webm',
     *   // 封面图片 url
     *   poster: '/path/video-1920x960-poster.jpg'
     * }]
     */
    sourceList: {
        res: string;
        url: string;
        poster: string;
    }[];
    /**
     * 播放分辨率
     * @example '1920x960'
     */
    playRes: string;
    /**
     * 插件属性，参数见文档
     * @see https://krpano.com/plugins/videoplayer/#attributes
     * @default
     * {
     *   loop: true,
     *   volume: 0
     * }
     */
    pluginAttrs?: {
        loop?: boolean;
        volume?: number;
    };
    children?: React.ReactNode;
    /**
     * 页面可见状态发生变化回调
     */
    onVisibility?: () => void;
}
export declare const VideoScene: FC<VideoSceneProps>;
//# sourceMappingURL=VideoScene.d.ts.map