import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { useContext, useEffect } from "react";
import { CurrentSceneContext, KrpanoRendererContext } from "../contexts";
import { buildXML } from "../utils";
export const Scene = ({ name, previewUrl, imageTagAttributes, images = [], content, children, }) => {
    const renderer = useContext(KrpanoRendererContext);
    const currentScene = useContext(CurrentSceneContext);
    useEffect(() => {
        const contentImageMeta = {
            tag: "image",
            // @ts-ignore
            attrs: imageTagAttributes,
            children: [],
        };
        // multires
        if (images.length > 1) {
            contentImageMeta.children.push(...images.map((_a) => {
                var { tiledImageWidth, tiledImageHeight } = _a, img = __rest(_a, ["tiledImageWidth", "tiledImageHeight"]);
                const imgXML = {
                    tag: "level",
                    attrs: {
                        tiledImageWidth,
                        tiledImageHeight,
                    },
                    children: [
                        {
                            tag: imageTagAttributes.type,
                            attrs: Object.assign({}, img),
                        },
                    ],
                };
                return imgXML;
            }));
        }
        else if (images.length === 1) {
            const img = __rest(images[0], []);
            contentImageMeta.children.push({
                tag: imageTagAttributes.type,
                attrs: Object.assign({}, img),
            });
        }
        renderer === null || renderer === void 0 ? void 0 : renderer.setTag("scene", name, {
            content: content ||
                `${previewUrl ? `<preview url="${previewUrl}" />` : ""}${images.length > 0 ? buildXML(contentImageMeta) : ""}`,
        });
        return () => {
            renderer === null || renderer === void 0 ? void 0 : renderer.removeScene(name);
        };
    }, [renderer, name, images, imageTagAttributes, content, previewUrl]);
    return _jsx("div", { className: "scene", children: currentScene === name ? children : null });
};
