/// <reference types="react" />
export interface SceneImageAttributes {
    type: "cube" | "sphere";
    /** 瓦片尺寸 */
    tileSize?: number;
    multires?: boolean;
}
export interface SceneImage {
    url: string;
}
export interface SceneImageWithMultires extends SceneImage {
    tiledImageWidth: number;
    tiledImageHeight: number;
}
export interface SceneProps {
    name: string;
    children?: React.ReactNode;
    previewUrl?: string;
    /** 直接指定scene的xml内容。指定后会忽略其他设置 */
    content?: string;
    /** image标签属性 */
    imageTagAttributes: SceneImageAttributes;
    /** Scene包含的图片。数组的长度大于1时按multires解析为多个level */
    images?: [SceneImage] | SceneImageWithMultires[];
}
export declare const Scene: React.FC<SceneProps>;
//# sourceMappingURL=Scene.d.ts.map