import { __rest } from "tslib";
import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import { useContext, useEffect } from "react";
import { KrpanoRendererContext } from "../contexts";
import { buildKrpanoAction, is121Version } from "../utils";
export const Plugin = (_a) => {
    var { name } = _a, attribute = __rest(_a, ["name"]);
    const renderer = useContext(KrpanoRendererContext);
    useEffect(() => {
        if (!renderer)
            return;
        if (is121Version) {
            const arr = [];
            for (const key in attribute) {
                arr.push(`${key}=${attribute[key]}`);
            }
            renderer.call(buildKrpanoAction("addplugin", name, ...arr));
            return () => {
                renderer.call(buildKrpanoAction("removeplugin", name));
            };
        }
        else {
            renderer.tagAction.pushSyncTag("plugin", Object.assign(Object.assign({}, attribute), { name }));
        }
    }, [renderer, name, attribute]);
    return _jsx(_Fragment, {});
};
