import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { memo, useContext, useEffect } from "react";
import { KrpanoRendererContext } from "../contexts";
export const Layer = memo((_a) => {
    var { name } = _a, rest = __rest(_a, ["name"]);
    const renderer = useContext(KrpanoRendererContext);
    useEffect(() => {
        renderer === null || renderer === void 0 ? void 0 : renderer.addLayer(name, {});
        return () => {
            renderer === null || renderer === void 0 ? void 0 : renderer.removeLayer(name);
        };
    }, []);
    useEffect(() => {
        renderer === null || renderer === void 0 ? void 0 : renderer.setTag("layer", name, Object.assign({}, rest), true);
    }, [renderer, name, rest]);
    return _jsx("div", { className: "layer" });
});
