import { __awaiter, __rest } from "tslib";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect, useState } from "react";
import { KrpanoActionProxy } from "../models";
import { useMounted, useEventCallback } from "../hooks";
import { CurrentSceneContext, KrpanoRendererContext } from "../contexts";
import { buildKrpanoAction } from "../utils";
import { WebVR } from "./WebVR";
import { Action } from "./Action";
import { Layer } from "./Layer";
import { Events } from "./Events";
export const Krpano = (_a) => {
    var { className, style, children, currentScene, target = "krpano", webvrUrl, webvrConfig, littlePlanetIntro, onReady } = _a, rest = __rest(_a, ["className", "style", "children", "currentScene", "target", "webvrUrl", "webvrConfig", "littlePlanetIntro", "onReady"]);
    const [renderer, setRenderer] = useState(null);
    const onReadyRef = useEventCallback(onReady);
    const onReadyCallback = useCallback((obj) => __awaiter(void 0, void 0, void 0, function* () {
        const krpano = new KrpanoActionProxy(obj);
        window[krpano.name] = krpano;
        krpano.littlePlanetIntro = littlePlanetIntro !== null && littlePlanetIntro !== void 0 ? littlePlanetIntro : false;
        setRenderer(krpano);
        if (onReadyRef.current) {
            onReadyRef.current(krpano);
        }
    }), [onReadyRef]);
    useEffect(() => {
        if (!renderer || !currentScene)
            return;
        renderer.tagAction.waitIncludeLoaded(true).then(() => {
            renderer.loadScene(currentScene);
            renderer.littlePlanetIntro &&
                renderer.call("skin_setup_littleplanetintro()");
            renderer.littlePlanetIntro = false;
        });
    }, [renderer, currentScene]);
    useEffect(() => {
        if (!renderer)
            return;
        reloadXML(renderer);
    }, [renderer]);
    const reloadXML = (krpano) => __awaiter(void 0, void 0, void 0, function* () {
        if (krpano.tagAction.syncTagStack.length) {
            // krpano 1.21 版本以下不支持动态插入 include，只能在文本中插入后重新加载
            const updateXmlString = new XMLSerializer().serializeToString(yield krpano.tagAction.createSyncTags());
            krpano.call(buildKrpanoAction("loadxml", updateXmlString));
        }
        krpano.tagAction.syncTagsLoaded = true;
        krpano.tagAction.queue.flushResolve(true);
    });
    const initKrpano = () => {
        const defaultConfig = {
            html5: "auto",
            xml: null,
            mobilescale: 1,
        };
        if (typeof window.embedpano === "function") {
            window.embedpano(Object.assign(Object.assign(Object.assign({}, defaultConfig), { target, onready: onReadyCallback }), rest));
        }
        else {
            throw new Error("Krpano required");
        }
    };
    const handleNewPano = () => {
        renderer === null || renderer === void 0 ? void 0 : renderer.set("layer[skin_loadingtext].visible", true);
    };
    const handleRemovePano = () => {
        renderer === null || renderer === void 0 ? void 0 : renderer.set("layer[skin_loadingtext].visible", true);
    };
    const handleLoadComplete = () => {
        setTimeout(() => {
            renderer === null || renderer === void 0 ? void 0 : renderer.set("layer[skin_loadingtext].visible", false);
        }, 200);
    };
    useMounted(() => {
        initKrpano();
    });
    return (_jsx(KrpanoRendererContext.Provider, { value: renderer, children: _jsxs(CurrentSceneContext.Provider, { value: currentScene || null, children: [webvrUrl && _jsx(WebVR, Object.assign({ url: webvrUrl }, webvrConfig)), _jsx("div", { id: target, className: className, style: style, children: renderer ? children : null }), _jsx(Events, { onNewPano: handleNewPano, onRemovePano: handleRemovePano, onLoadComplete: handleLoadComplete }), _jsx(Layer, { name: "skin_loadingtext", type: "text", align: "center", x: 5, y: -5, keep: true, html: "\u52A0\u8F7D\u4E2D...", visible: false, background: false, border: false, enabled: false, css: "color:#FFFFFF; font-family:Arial; text-align:center; font-style:italic; font-size:22px;" }), _jsx(Action, { name: "skin_setup_littleplanetintro", content: `
            copy(lp_scene, xml.scene);
            copy(lp_hlookat, view.hlookat);
            copy(lp_vlookat, view.vlookat);
            copy(lp_fov, view.fov);
            copy(lp_fovmax, view.fovmax);
            copy(lp_limitview, view.limitview);
            copy(lp_usercontrol, control.usercontrol);
            set(view.fovmax, 170);
            set(view.limitview, lookto);
            set(view.vlookatmin, 90);
            set(view.vlookatmax, 90);
            lookat(calc(lp_hlookat - 180), 90, 150, 1, 0, 0);
            set(events[lp_events].onloadcomplete,
              delayedcall(0.5,
                if(lp_scene === xml.scene,
                  set(control.usercontrol, off);
                  copy(view.limitview, lp_limitview);
                  set(view.vlookatmin, null);
                  set(view.vlookatmax, null);
                  tween(view.hlookat|view.vlookat|view.fov|view.distortion, calc('' + lp_hlookat + '|' + lp_vlookat + '|' + lp_fov + '|' + 0.0),
                    3.0, easeOutQuad,
                    set(control.usercontrol, get(lp_usercontrol));
                    tween(view.fovmax, get(lp_fovmax));
                    );
                  );
                );
              );
          ` }), _jsx(Action, { name: "draggable_hotspot", content: `
            asyncloop(pressed, screentosphere(mouse.stagex, mouse.stagey, ath, atv); js(draggbleHotspotEvent(get(ath), get(atv))));
          ` })] }) }));
};
