import React from "react";
import { KrpanoActionProxy } from "../models";
import { IKrpanoConfig } from "../types";
export interface KrpanoProps extends Omit<IKrpanoConfig, "onready" | "target"> {
    className?: string;
    style?: React.CSSProperties;
    children?: React.ReactNode;
    currentScene?: string;
    target?: string;
    /**
     * webvr.xml 地址，需遵循同源策略
     */
    webvrUrl?: string;
    webvrConfig?: Record<string, unknown>;
    /**
     * 小行星视角
     */
    littlePlanetIntro?: boolean;
    onReady?: (renderer: KrpanoActionProxy) => void;
}
export declare const Krpano: React.FC<KrpanoProps>;
//# sourceMappingURL=Krpano.d.ts.map