import { __awaiter, __rest } from "tslib";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect, useState } from "react";
import { KrpanoActionProxy } from "../models";
import { useMounted, useEventCallback } from "../hooks";
import { CurrentSceneContext, KrpanoRendererContext } from "../contexts";
import { buildKrpanoAction } from "../utils";
import { WebVR } from "./WebVR";
import { Action } from "./Action";
import { Events } from "./Events";
export const Krpano = (_a) => {
    var { className, style, children, currentScene, target = "krpano", webvrUrl, webvrConfig, gyroUrl, onReady } = _a, rest = __rest(_a, ["className", "style", "children", "currentScene", "target", "webvrUrl", "webvrConfig", "gyroUrl", "onReady"]);
    const [renderer, setRenderer] = useState(null);
    const onReadyRef = useEventCallback(onReady);
    const onReadyCallback = useCallback((obj) => {
        const renderer = new KrpanoActionProxy(obj);
        window[renderer.name] = renderer;
        setRenderer(renderer);
        if (onReadyRef.current) {
            onReadyRef.current(renderer);
        }
    }, [onReadyRef]);
    useEffect(() => {
        if (!renderer)
            return;
        const reloadXML = () => __awaiter(void 0, void 0, void 0, function* () {
            if (renderer.tagAction.syncTagStack.length) {
                // krpano 1.21 版本以下不支持动态插入 include，只能在文本中插入后重新加载
                const updateXmlString = new XMLSerializer().serializeToString(yield renderer.tagAction.createSyncTags());
                console.log(updateXmlString);
                renderer.call(buildKrpanoAction("loadxml", updateXmlString));
            }
            renderer.tagAction.syncTagsLoaded = true;
            renderer.tagAction.queue.flushResolve(true);
        });
        reloadXML();
    }, [renderer]);
    useEffect(() => {
        if (!renderer || !currentScene)
            return;
        renderer.tagAction.waitIncludeLoaded(true).then(() => {
            renderer.loadScene(currentScene);
        });
    }, [renderer, currentScene]);
    const initKrpano = () => {
        const defaultConfig = {
            html5: "auto",
            xml: null,
            mobilescale: 1,
        };
        if (typeof window.embedpano === "function") {
            window.embedpano(Object.assign(Object.assign(Object.assign({}, defaultConfig), { target, onready: onReadyCallback }), rest));
        }
        else {
            throw new Error("Krpano required");
        }
    };
    useMounted(() => {
        initKrpano();
    });
    return (_jsx(KrpanoRendererContext.Provider, { value: renderer, children: _jsxs(CurrentSceneContext.Provider, { value: currentScene || null, children: [webvrUrl && _jsx(WebVR, Object.assign({ url: webvrUrl }, webvrConfig)), _jsx("div", { id: target, className: className, style: style, children: renderer ? children : null }), _jsx(Events, { onLoadComplete: () => {
                        console.log("--");
                    } }), _jsx(Action, { name: "skin_setup_littleplanetintro", content: `
            copy(lp_scene, xml.scene);
            copy(lp_hlookat, view.hlookat);
            copy(lp_vlookat, view.vlookat);
            copy(lp_fov, view.fov);
            copy(lp_fovmax, view.fovmax);
            copy(lp_limitview, view.limitview);
            set(view.fovmax, 170);
            set(view.limitview, lookto);
            set(view.vlookatmin, 90);
            set(view.vlookatmax, 90);
            lookat(calc(lp_hlookat - 180), 90, 150, 1, 0, 0);
            set(events[lp_events].onloadcomplete,
              delayedcall(0.5,
                if(lp_scene === xml.scene,
                  set(control.usercontrol, off);
                  copy(view.limitview, lp_limitview);
                  set(view.vlookatmin, null);
                  set(view.vlookatmax, null);
                  tween(view.hlookat|view.vlookat|view.fov|view.distortion, calc('' + lp_hlookat + '|' + lp_vlookat + '|' + lp_fov + '|' + 0.0),
                    3.0, easeOutQuad,
                    set(control.usercontrol, all);
                    tween(view.fovmax, get(lp_fovmax));
                    );
                  );
                );
              );
          ` })] }) }));
};
