import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import { useContext, useEffect } from "react";
import { KrpanoRendererContext } from "../contexts";
import { buildKrpanoAction, is121Version } from "../utils";
export const Include = ({ url }) => {
    const renderer = useContext(KrpanoRendererContext);
    useEffect(() => {
        if (!renderer)
            return;
        if (is121Version) {
            renderer.call(buildKrpanoAction("includexml", url));
        }
        else {
            renderer.tagAction.pushSyncTag("include", { url });
        }
    }, [renderer]);
    return _jsx(_Fragment, {});
};
