import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { useContext, useEffect } from "react";
import { KrpanoRendererContext } from "../contexts";
export const KrpanoImg = (_a) => {
    var { children } = _a, attrs = __rest(_a, ["children"]);
    const renderer = useContext(KrpanoRendererContext);
    useEffect(() => {
        if (!renderer)
            return;
        renderer.call(`
      addimage(image_sphere);
      set(image_sphere.type, sphere);
      set(image_sphere.url, 'plugin:video');
      set(image_sphere.preload, true);
      set(image_sphere.onload, 'trace("Video Loaded!");');
    `);
    }, [renderer, attrs]);
    return _jsx("div", { className: "krpano-img", children: children });
};
