import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { memo, useContext, useEffect, useMemo } from "react";
import { KrpanoRendererContext } from "../contexts";
import { buildKrpanoAction, childrenToOuterHTML, mapEventPropsToJSCall, mapObject, } from "../utils";
export const HotSpot = memo((_a) => {
    var { name } = _a, rest = __rest(_a, ["name"]);
    const EventSelector = `hotspot[${name}]`;
    const renderer = useContext(KrpanoRendererContext);
    const options = useMemo(() => {
        const { scale = 0.5, children } = rest, r = __rest(rest, ["scale", "children"]);
        return Object.assign({ scale, html: r.type === "text" ? childrenToOuterHTML(children) : null, onOver: buildKrpanoAction("tween", "scale", scale + 0.05), onOut: buildKrpanoAction("tween", "scale", scale) }, r);
    }, [rest]);
    useEffect(() => {
        const eventsObj = mapObject(Object.assign({}, options), (key, value) => {
            if (key.startsWith("on") && typeof value === "function") {
                return {
                    [key]: value,
                };
            }
            return {};
        });
        renderer === null || renderer === void 0 ? void 0 : renderer.bindEvents(EventSelector, eventsObj);
        renderer === null || renderer === void 0 ? void 0 : renderer.addHotspot(name, {});
        return () => {
            renderer === null || renderer === void 0 ? void 0 : renderer.unbindEvents(EventSelector, eventsObj);
            renderer === null || renderer === void 0 ? void 0 : renderer.removeHotspot(name);
        };
    }, []);
    useEffect(() => {
        if (!renderer)
            return;
        renderer.setTag("hotspot", name, Object.assign(Object.assign({}, options), mapEventPropsToJSCall(Object.assign({}, options), (key) => `js(${renderer.name}.fire(${key},${EventSelector}))`)), true);
    }, [renderer, name, options]);
    return _jsx("div", { className: "hotspot" });
});
