import { FC, ReactNode } from "react";
import { EventCallback } from "../types";
export interface HotspotProps {
    name: string;
    children?: ReactNode;
    url?: string;
    /**
     * @see https://krpano.com/docu/xml/?version=121#layer.type
     */
    type?: "image" | "text";
    keep?: boolean;
    visible?: boolean;
    enabled?: boolean;
    handCursor?: boolean;
    cursor?: string;
    maskChildren?: boolean;
    zOrder?: string;
    style?: string;
    /**
     * 水平方向
     */
    ath?: number;
    /**
     * 垂直方向
     */
    atv?: number;
    edge?: string;
    zoom?: boolean;
    distorted?: boolean;
    rx?: number;
    ry?: number;
    rz?: number;
    width?: string;
    height?: string;
    /**
     * 比例
     * @default 0.5
     */
    scale?: number;
    rotate?: number;
    alpha?: number;
    bg?: boolean;
    bgcolor?: string;
    bgalpha?: number;
    bgborder?: number;
    bgbordermode?: "outside" | "inside";
    bgborderblend?: boolean;
    onOver?: EventCallback;
    onHover?: EventCallback;
    onOut?: EventCallback;
    onDown?: EventCallback | string;
    onUp?: EventCallback;
    onClick?: EventCallback;
    onLoaded?: EventCallback;
}
export declare const HotSpot: FC<HotspotProps>;
//# sourceMappingURL=HotSpot.d.ts.map