import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { useContext, useEffect } from "react";
import { KrpanoRendererContext } from "../contexts/KrpanoRendererContext";
import { mapEventPropsToJSCall } from "../utils";
const GlobalEvents = "__GlobalEvents";
export const Events = (_a) => {
    var { name, keep } = _a, EventsAttrs = __rest(_a, ["name", "keep"]);
    const renderer = useContext(KrpanoRendererContext);
    const EventSelector = `events[${name || GlobalEvents}]`;
    // 在renderer上绑定回调
    useEffect(() => {
        renderer === null || renderer === void 0 ? void 0 : renderer.bindEvents(EventSelector, Object.assign({}, EventsAttrs));
        return () => {
            renderer === null || renderer === void 0 ? void 0 : renderer.unbindEvents(EventSelector, Object.assign({}, EventsAttrs));
        };
    }, [renderer, EventsAttrs]);
    // Krpano标签上添加js call，触发事件
    useEffect(() => {
        renderer === null || renderer === void 0 ? void 0 : renderer.setTag("events", 
        // 全局事件直接设置
        name || null, Object.assign(Object.assign({}, mapEventPropsToJSCall(Object.assign({}, EventsAttrs), (eventName) => `js(${renderer.name}.fire(${eventName},${EventSelector}))`)), { keep }), true);
    }, [name, renderer]);
    return _jsx("div", { className: "events" });
};
