import { FC } from "react";
import { EventCallback } from "../types";
/**
 * @see https://krpano.com/docu/xml/#events
 */
export interface EventsConfig {
    /** 事件名，若存在该参数则为局部事件 */
    name?: string;
    keep?: boolean;
    onEnterFullscreen?: EventCallback;
    onExitFullscreen?: EventCallback;
    onXmlComplete?: EventCallback;
    onPreviewComplete?: EventCallback;
    onLoadComplete?: EventCallback;
    onBlendComplete?: EventCallback;
    onNewPano?: EventCallback;
    onRemovePano?: EventCallback;
    onNewScene?: EventCallback;
    onXmlError?: EventCallback;
    onLoadError?: EventCallback;
    onKeydown?: EventCallback;
    onKeyup?: EventCallback;
    onClick?: EventCallback;
    onSingleClick?: EventCallback;
    onDoubleClick?: EventCallback;
    onMousedown?: EventCallback;
    onMouseup?: EventCallback;
    onMousewheel?: EventCallback;
    onContextmenu?: EventCallback;
    onIdle?: EventCallback;
    onViewChange?: EventCallback;
    onViewChanged?: EventCallback;
    onResize?: EventCallback;
    onFrameBufferResize?: EventCallback;
    /**
     * 启动自动旋转时回调
     */
    onAutoRotateStart?: EventCallback;
    /**
     * 停止自动旋转时回调
     */
    onAutoRotateStop?: EventCallback;
    /**
     * 全景图完成一轮自动旋转时回调
     */
    onAutoRotateOneRound?: EventCallback;
    /**
     * 自动旋转状态发生改变时回调
     */
    onAutoRotateChange?: EventCallback;
    onIPhoneFullscreen?: EventCallback;
}
export interface EventsProps extends EventsConfig {
}
export declare const Events: FC<EventsProps>;
//# sourceMappingURL=Events.d.ts.map