import { jsx as _jsx } from "react/jsx-runtime";
import { useContext, useEffect } from "react";
import { KrpanoRendererContext } from "../contexts";
export const DEFAULT_CONTROL_PROPS = {
    mode: "drag",
    usercontrol: "all",
    invert: false,
};
export const Control = (props) => {
    const renderer = useContext(KrpanoRendererContext);
    useEffect(() => {
        if (!renderer)
            return;
        renderer.tagAction.pushSyncTag("control", Object.assign({}, DEFAULT_CONTROL_PROPS, props));
    }, [renderer]);
    return _jsx("div", { className: "control" });
};
