import { FC } from "react";
/**
 * @see https://krpano.com/docu/xml/#control
 */
export interface ControlProps {
    /**
     * 控制方式
     * @default 'moveto'
     */
    mode?: "drag" | "follow" | "moveto";
    /**
     * 控制用户是否可以交互
     * @default 'all'
     */
    usercontrol?: "all" | "mouse" | "keyb" | "off";
    /**
     * 是否反转控制方向
     * @default false
     */
    invert?: boolean;
    [key: string]: unknown;
}
export declare const DEFAULT_CONTROL_PROPS: ControlProps;
export declare const Control: FC<ControlProps>;
//# sourceMappingURL=Control.d.ts.map