export interface PromiseQueueItem<T> {
    resolve(value: T): void;
    reject(error: Error): void;
}
export declare class PromiseQueue<T> {
    private queue;
    /**
     * 返回一个 promise 用于等待
     */
    push: () => Promise<T>;
    unshift: () => Promise<T>;
    /**
     * 清空队列, 正常结束
     */
    flushResolve: (value: T) => void;
    /**
     * 清空队列, 移除结束
     */
    flushReject: (error: Error) => void;
}
//# sourceMappingURL=PromiseQueue.d.ts.map