import { PromiseQueue } from "./PromiseQueue";
import { NativeKrpanoRendererObject, ROTATE_DIRECTION, ZOOM_ACTION } from "./types";
export type HandlerFunc = (renderer: KrpanoActionProxy) => void;
interface EventHandler {
    eventName: string;
    selector: string;
    handler: HandlerFunc;
}
export declare class KrpanoActionProxy {
    name: string;
    krpanoRenderer?: NativeKrpanoRendererObject;
    eventHandlers: EventHandler[];
    dynamicTagWaitQueue: PromiseQueue<any>;
    constructor(krpanoRenderer?: NativeKrpanoRendererObject, name?: string);
    /**
     * 等待 include 标签加载完成
     */
    waitIncludeLoaded(push?: boolean): Promise<any>;
    /**
     * 执行 Javascript 函数
     * @param action 动作
     * @param nexttick 是否在下一个渲染帧后执行
     */
    call(action: string, nexttick?: boolean): void;
    set(name: string, ...params: Array<string | number | boolean>): void;
    /**
     * 动态添加标签
     * @param tag 标签
     * @param name 名称
     * @param attrs 属性
     */
    setTag(tag: "scene" | "hotspot" | "layer" | "view" | "events" | "autorotate", name: string | null, attrs: Record<string, any>): Promise<void>;
    get<T = any>(name: string): T;
    /**
     * 删除场景
     * @param name 场景名称
     */
    removeScene(name: string): void;
    /**
     * 加载场景
     * @param name 场景 name
     */
    loadScene(name: string): void;
    /**
     * 旋转视图
     * @param direction 方位
     * @param degrees 旋转度数，默认为 10
     */
    rotateView(direction: ROTATE_DIRECTION, degrees?: number): void;
    /**
     * 缩放视图
     * @param action 动作
     * @param num 缩放大小
     */
    zoomView(action: ZOOM_ACTION, num?: number): void;
    on(eventName: string, selector: string, handler: HandlerFunc): this;
    off(eventName: string, selector: string, handler: HandlerFunc): void;
    fire(eventName: string, selector: string): void;
    bindEvents(selector: string, mapEventsToHandler: Record<string, HandlerFunc | undefined>): void;
    unbindEvents(selector: string, mapEventsToHandler: Record<string, HandlerFunc | undefined>): void;
    addHotspot(name: string, attrs: Record<string, string | boolean | number | undefined>): Promise<void>;
    removeHotspot(name: string): void;
    syncTagsLoaded: boolean;
    syncTagStack: {
        tagName: string;
        attribute: Record<string, unknown>;
    }[];
    pushSyncTag(tagName: string, attribute: Record<string, unknown>): void;
    createSyncTags(): Promise<Document>;
    private getXMLContent;
}
export {};
//# sourceMappingURL=KrpanoActionProxy.d.ts.map