/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ModelBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;

@Component
public class ApiModelReader {
    private static final Logger LOG = LoggerFactory.getLogger(ApiModelReader.class);
    private final ModelProvider modelProvider;
    private final TypeResolver typeResolver;
    private final DocumentationPluginsManager pluginsManager;

    @Autowired
    public ApiModelReader(@Qualifier(value="cachedModels") ModelProvider modelProvider, TypeResolver typeResolver, DocumentationPluginsManager pluginsManager) {
        this.modelProvider = modelProvider;
        this.typeResolver = typeResolver;
        this.pluginsManager = pluginsManager;
    }

    public Map<String, Model> read(RequestMappingContext context) {
        HashSet ignorableTypes = Sets.newHashSet((Iterable)context.getDocumentationContext().getIgnorableParameterTypes());
        Set<ModelContext> modelContexts = this.pluginsManager.modelContexts(context);
        HashMap modelMap = Maps.newHashMap((Map)context.getModelMap());
        for (ModelContext each : modelContexts) {
            this.markIgnorablesAsHasSeen(this.typeResolver, ignorableTypes, each);
            Optional pModel = this.modelProvider.modelFor(each);
            if (pModel.isPresent()) {
                LOG.debug("Generated parameter model id: {}, name: {}, schema: {} models", (Object)((Model)pModel.get()).getId(), (Object)((Model)pModel.get()).getName());
                this.mergeModelMap(modelMap, (Model)pModel.get());
            } else {
                LOG.debug("Did not find any parameter models for {}", (Object)each.getType());
            }
            this.populateDependencies(each, modelMap);
        }
        return modelMap;
    }

    private void mergeModelMap(Map<String, Model> target, Model source) {
        String sourceModelKey = source.getId();
        if (!target.containsKey(sourceModelKey)) {
            LOG.debug("Adding a new model with key {}", (Object)sourceModelKey);
            target.put(sourceModelKey, source);
        } else {
            Model targetModelValue = target.get(sourceModelKey);
            Map targetProperties = targetModelValue.getProperties();
            Map sourceProperties = source.getProperties();
            HashSet newSourcePropKeys = Sets.newHashSet(sourceProperties.keySet());
            newSourcePropKeys.removeAll(targetProperties.keySet());
            HashMap mergedTargetProperties = Maps.newHashMap((Map)targetProperties);
            for (String newProperty : newSourcePropKeys) {
                LOG.debug("Adding a missing property {} to model {}", (Object)newProperty, (Object)sourceModelKey);
                mergedTargetProperties.put(newProperty, sourceProperties.get(newProperty));
            }
            Model mergedModel = new ModelBuilder().id(targetModelValue.getId()).name(targetModelValue.getName()).type(targetModelValue.getType()).qualifiedType(targetModelValue.getQualifiedType()).properties((Map)mergedTargetProperties).description(targetModelValue.getDescription()).baseModel(targetModelValue.getBaseModel()).discriminator(targetModelValue.getDiscriminator()).subTypes(targetModelValue.getSubTypes()).build();
            target.put(sourceModelKey, mergedModel);
        }
    }

    private void markIgnorablesAsHasSeen(TypeResolver typeResolver, Set<Class> ignorableParameterTypes, ModelContext modelContext) {
        for (Class ignorableParameterType : ignorableParameterTypes) {
            modelContext.seen(typeResolver.resolve((Type)ignorableParameterType, new Type[0]));
        }
    }

    private void populateDependencies(ModelContext modelContext, Map<String, Model> modelMap) {
        Map dependencies = this.modelProvider.dependencies(modelContext);
        for (Model each : dependencies.values()) {
            this.mergeModelMap(modelMap, each);
        }
    }
}

