/*
 * Decompiled with CFR 0.152.
 */
package com.platform.util.wechat;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.platform.util.wechat.MD5;
import com.platform.util.wechat.WechatConfig;
import com.platform.util.wechat.WechatRefundApiResult;
import com.platform.utils.CharUtil;
import com.platform.utils.MapUtils;
import com.platform.utils.ResourceUtil;
import com.platform.utils.XmlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class WechatUtil {
    private static Log logger = LogFactory.getLog(WechatUtil.class);
    public static Integer CLIENTTYPE_WX = 2;
    public static Integer CLIENTTYPE_APP = 1;

    public static WechatRefundApiResult wxRefund(String out_trade_no, Double orderMoney, Double refundMoney) {
        BigDecimal bdOrderMoney = new BigDecimal(orderMoney, MathContext.DECIMAL32);
        BigDecimal bdRefundMoney = new BigDecimal(refundMoney, MathContext.DECIMAL32);
        Map<Object, Object> params = WechatUtil.buildRequsetMapParam(out_trade_no, bdOrderMoney, bdRefundMoney);
        String mapToXml = MapUtils.convertMap2Xml(params);
        String reponseXml = WechatUtil.sendSSLPostToWx(mapToXml, WechatConfig.getSslcsf());
        WechatRefundApiResult result = (WechatRefundApiResult)XmlUtil.xmlStrToBean((String)reponseXml, WechatRefundApiResult.class);
        return result;
    }

    private static Map<Object, Object> buildRequsetMapParam(String out_trade_no, BigDecimal bdOrderMoney, BigDecimal bdRefundMoney) {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("appid", ResourceUtil.getConfigByName((String)"wx.appId"));
        params.put("mch_id", ResourceUtil.getConfigByName((String)"wx.mchId"));
        params.put("nonce_str", CharUtil.getRandomString((Integer)16));
        params.put("out_trade_no", out_trade_no);
        params.put("out_refund_no", WechatUtil.getBundleId());
        params.put("total_fee", bdOrderMoney.multiply(new BigDecimal(100)).intValue());
        params.put("refund_fee", bdRefundMoney.multiply(new BigDecimal(100)).intValue());
        params.put("op_user_id", ResourceUtil.getConfigByName((String)"wx.mchId"));
        params.put("sign", WechatUtil.arraySign(params, ResourceUtil.getConfigByName((String)"wx.paySignKey")));
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendSSLPostToWx(String mapToXml, SSLConnectionSocketFactory sslcsf) {
        logger.info("*******\u9000\u6b3e\uff08WX Request\uff1a" + mapToXml);
        HttpPost httPost = new HttpPost(ResourceUtil.getConfigByName((String)"wx.refundUrl"));
        httPost.addHeader("Connection", "keep-alive");
        httPost.addHeader("Accept", "*/*");
        httPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        httPost.addHeader("Host", "api.mch.weixin.qq.com");
        httPost.addHeader("X-Requested-With", "XMLHttpRequest");
        httPost.addHeader("Cache-Control", "max-age=0");
        httPost.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0) ");
        httPost.setEntity((HttpEntity)new StringEntity(mapToXml, "UTF-8"));
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslcsf).build();
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httPost);
            HttpEntity entity = response.getEntity();
            String xmlStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            logger.info("*******\u9000\u6b3e\uff08WX Response\uff1a" + xmlStr);
            String string = xmlStr;
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> wxRefundquery(String out_trade_no, String out_refund_no) {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("appid", ResourceUtil.getConfigByName((String)"wx.appId"));
        params.put("mch_id", ResourceUtil.getConfigByName((String)"wx.mchId"));
        params.put("nonce_str", CharUtil.getRandomString((Integer)16));
        params.put("out_trade_no", out_trade_no);
        params.put("sign", WechatUtil.arraySign(params, ResourceUtil.getConfigByName((String)"wx.paySignKey")));
        String mapToXml = MapUtils.convertMap2Xml(params);
        HttpPost httPost = new HttpPost(ResourceUtil.getConfigByName((String)"wx.refundqueryUrl"));
        httPost.addHeader("Connection", "keep-alive");
        httPost.addHeader("Accept", "*/*");
        httPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        httPost.addHeader("Host", "api.mch.weixin.qq.com");
        httPost.addHeader("X-Requested-With", "XMLHttpRequest");
        httPost.addHeader("Cache-Control", "max-age=0");
        httPost.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0) ");
        httPost.setEntity((HttpEntity)new StringEntity(mapToXml, "UTF-8"));
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)WechatConfig.getSslcsf()).build();
        CloseableHttpResponse response = null;
        try {
            Map result;
            response = httpClient.execute((HttpUriRequest)httPost);
            HttpEntity entity = response.getEntity();
            String xmlStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            System.out.println(xmlStr);
            Map map = result = XmlUtil.xmlStrToMap((String)xmlStr);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Map<String, Object> map = null;
            return map;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String getBundleId() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String tradeno = dateFormat.format(new Date());
        String str = "000000" + (int)(Math.random() * 1000000.0);
        tradeno = tradeno + str.substring(str.length() - 6);
        return tradeno;
    }

    public static String arraySign(Map<Object, Object> params, String paySignKey) {
        boolean encode = false;
        Set<Object> keysSet = params.keySet();
        Object[] keys = keysSet.toArray();
        Arrays.sort(keys);
        StringBuffer temp = new StringBuffer();
        boolean first = true;
        for (Object key : keys) {
            if (first) {
                first = false;
            } else {
                temp.append("&");
            }
            temp.append(key).append("=");
            Object value = params.get(key);
            String valueString = "";
            if (null != value) {
                valueString = value.toString();
            }
            if (encode) {
                try {
                    temp.append(URLEncoder.encode(valueString, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                continue;
            }
            temp.append(valueString);
        }
        temp.append("&key=");
        temp.append(paySignKey);
        System.out.println(temp.toString());
        String packageSign = MD5.getMessageDigest(temp.toString());
        return packageSign;
    }

    public static String requestOnce(String url, String data) throws Exception {
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build(), null, null, null);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(10000).build();
        httpPost.setConfig(requestConfig);
        StringEntity postEntity = new StringEntity(data, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.addHeader("User-Agent", "wxpay sdk java v1.0 " + ResourceUtil.getConfigByName((String)"wx.mchId"));
        httpPost.setEntity((HttpEntity)postEntity);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        String reusltObj = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
        logger.info("\u8bf7\u6c42\u7ed3\u679c:" + reusltObj);
        return reusltObj;
    }
}

