/*
 * Decompiled with CFR 0.152.
 */
package com.platform.util.wechat;

import com.platform.utils.ResourceUtil;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatConfig {
    private static final Logger log = LoggerFactory.getLogger(WechatConfig.class);
    private static SSLConnectionSocketFactory sslcsf;

    public static SSLConnectionSocketFactory getSslcsf() {
        if (null == sslcsf) {
            WechatConfig.setSsslcsf();
        }
        return sslcsf;
    }

    private static void setSsslcsf() {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            Thread.currentThread().getContextClassLoader();
            log.info("wx.certName:" + ResourceUtil.getConfigByName((String)"wx.certName"));
            try (FileInputStream instream = new FileInputStream(ResourceUtil.getConfigByName((String)"wx.certName"));){
                keyStore.load(instream, ResourceUtil.getConfigByName((String)"wx.mchId").toCharArray());
            }
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, ResourceUtil.getConfigByName((String)"wx.mchId").toCharArray()).build();
            sslcsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

