/*
 * Decompiled with CFR 0.152.
 */
package com.platform.util;

import com.alibaba.fastjson.JSONObject;
import com.platform.entity.TokenEntity;
import com.platform.service.TokenService;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;

public class ApiBaseAction {
    protected Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    @Autowired
    protected TokenService tokenService;

    @ExceptionHandler(value={BindException.class, MissingServletRequestParameterException.class, UnauthorizedException.class, TypeMismatchException.class})
    @ResponseBody
    public Map<String, Object> bindException(Exception e) {
        if (e instanceof BindException) {
            return this.toResponsObject(1, "\u53c2\u6570\u7ed1\u5b9a\u5f02\u5e38", e.getMessage());
        }
        if (e instanceof UnauthorizedException) {
            return this.toResponsObject(1, "\u65e0\u8bbf\u95ee\u6743\u9650", e.getMessage());
        }
        return this.toResponsObject(1, "\u5904\u7406\u5f02\u5e38", e.getMessage());
    }

    public Map<String, Object> toResponsObject(int requestCode, String msg, Object data) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("errno", requestCode);
        obj.put("errmsg", msg);
        if (data != null) {
            obj.put("data", data);
        }
        return obj;
    }

    public Map<String, Object> toResponsSuccess(Object data) {
        Map<String, Object> rp = this.toResponsObject(0, "\u6267\u884c\u6210\u529f", data);
        this.logger.info((Object)("response:" + rp));
        return rp;
    }

    public Map<String, Object> toResponsMsgSuccess(String msg) {
        return this.toResponsObject(0, msg, "");
    }

    public Map<String, Object> toResponsSuccessForSelect(Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("list", data);
        return this.toResponsObject(0, "\u6267\u884c\u6210\u529f", result);
    }

    public Map<String, Object> toResponsFail(String msg) {
        return this.toResponsObject(1, msg, null);
    }

    @InitBinder
    public void initBinder(WebDataBinder binder, WebRequest request) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    public String getClientIp() {
        String xff = this.request.getHeader("X-Real-IP");
        if (xff != null) {
            return xff;
        }
        xff = this.request.getHeader("x-forwarded-for");
        if (xff == null) {
            return "8.8.8.8";
        }
        return xff;
    }

    public JSONObject getJsonRequest() {
        JSONObject result = null;
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = this.request.getReader();){
            int len;
            char[] buff = new char[1024];
            while ((len = reader.read(buff)) != -1) {
                sb.append(buff, 0, len);
            }
            result = JSONObject.parseObject((String)sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Long getUserId() {
        String token = this.request.getHeader("X-Nideshop-Token");
        TokenEntity tokenEntity = this.tokenService.queryByToken(token);
        if (tokenEntity == null || tokenEntity.getExpireTime().getTime() < System.currentTimeMillis()) {
            return null;
        }
        return tokenEntity.getUserId();
    }
}

