/*
 * Decompiled with CFR 0.152.
 */
package com.platform.service;

import com.platform.dao.ApiTokenMapper;
import com.platform.entity.TokenEntity;
import com.platform.utils.CharUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Autowired
    private ApiTokenMapper tokenDao;
    private static final Long EXPIRE = 2592000L;

    public TokenEntity queryByUserId(Long userId) {
        return this.tokenDao.queryByUserId(userId);
    }

    public TokenEntity queryByToken(String token) {
        return this.tokenDao.queryByToken(token);
    }

    public void save(TokenEntity token) {
        this.tokenDao.save(token);
    }

    public void update(TokenEntity token) {
        this.tokenDao.update(token);
    }

    public Map<String, Object> createToken(long userId) {
        String token = CharUtil.getRandomString((Integer)32);
        Date now = new Date();
        Date expireTime = new Date(now.getTime() + EXPIRE * 1000L);
        TokenEntity tokenEntity = this.queryByUserId(userId);
        if (tokenEntity == null) {
            tokenEntity = new TokenEntity();
            tokenEntity.setUserId(userId);
            tokenEntity.setToken(token);
            tokenEntity.setUpdateTime(now);
            tokenEntity.setExpireTime(expireTime);
            this.save(tokenEntity);
        } else {
            tokenEntity.setToken(token);
            tokenEntity.setUpdateTime(now);
            tokenEntity.setExpireTime(expireTime);
            this.update(tokenEntity);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", token);
        map.put("expire", EXPIRE);
        return map;
    }
}

