/*
 * Decompiled with CFR 0.152.
 */
package com.platform.service;

import com.platform.dao.ApiUserLevelMapper;
import com.platform.dao.ApiUserMapper;
import com.platform.entity.SmsLogVo;
import com.platform.entity.UserLevelVo;
import com.platform.entity.UserVo;
import com.platform.utils.RRException;
import com.platform.validator.Assert;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiUserService {
    @Autowired
    private ApiUserMapper userDao;
    @Autowired
    private ApiUserLevelMapper userLevelDao;

    public UserVo queryObject(Long userId) {
        return (UserVo)this.userDao.queryObject(userId);
    }

    public UserVo queryByOpenId(String openId) {
        return this.userDao.queryByOpenId(openId);
    }

    public List<UserVo> queryList(Map<String, Object> map) {
        return this.userDao.queryList(map);
    }

    public int queryTotal(Map<String, Object> map) {
        return this.userDao.queryTotal(map);
    }

    public void save(String mobile, String password) {
        UserVo user = new UserVo();
        user.setMobile(mobile);
        user.setUsername(mobile);
        user.setPassword(DigestUtils.sha256Hex((String)password));
        user.setRegister_time(new Date());
        this.userDao.save(user);
    }

    public void save(UserVo userVo) {
        this.userDao.save(userVo);
    }

    public void update(UserVo user) {
        this.userDao.update(user);
    }

    public void delete(Long userId) {
        this.userDao.delete(userId);
    }

    public void deleteBatch(Long[] userIds) {
        this.userDao.deleteBatch(userIds);
    }

    public UserVo queryByMobile(String mobile) {
        return this.userDao.queryByMobile(mobile);
    }

    public long login(String mobile, String password) {
        UserVo user = this.queryByMobile(mobile);
        Assert.isNull((Object)user, (String)"\u624b\u673a\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        if (!user.getPassword().equals(DigestUtils.sha256Hex((String)password))) {
            throw new RRException("\u624b\u673a\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return user.getUserId();
    }

    public SmsLogVo querySmsCodeByUserId(Long user_id) {
        return this.userDao.querySmsCodeByUserId(user_id);
    }

    public int saveSmsCodeLog(SmsLogVo smsLogVo) {
        return this.userDao.saveSmsCodeLog(smsLogVo);
    }

    public String getUserLevel(UserVo loginUser) {
        String result = "\u666e\u901a\u7528\u6237";
        UserLevelVo userLevelVo = (UserLevelVo)this.userLevelDao.queryObject(loginUser.getUser_level_id());
        if (null != userLevelVo) {
            result = userLevelVo.getName();
        }
        return result;
    }
}

