/*
 * Decompiled with CFR 0.152.
 */
package com.platform.service;

import com.alibaba.fastjson.JSONObject;
import com.platform.cache.J2CacheUtils;
import com.platform.dao.ApiAddressMapper;
import com.platform.dao.ApiCartMapper;
import com.platform.dao.ApiCouponMapper;
import com.platform.dao.ApiOrderGoodsMapper;
import com.platform.dao.ApiOrderMapper;
import com.platform.entity.AddressVo;
import com.platform.entity.BuyGoodsVo;
import com.platform.entity.CartVo;
import com.platform.entity.CouponVo;
import com.platform.entity.GoodsVo;
import com.platform.entity.OrderGoodsVo;
import com.platform.entity.OrderShippingVo;
import com.platform.entity.OrderVo;
import com.platform.entity.ProductVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiGoodsService;
import com.platform.service.ApiOrderShippingService;
import com.platform.service.ApiProductService;
import com.platform.util.CommonUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiOrderService {
    @Autowired
    private ApiOrderMapper orderDao;
    @Autowired
    private ApiAddressMapper apiAddressMapper;
    @Autowired
    private ApiCartMapper apiCartMapper;
    @Autowired
    private ApiCouponMapper apiCouponMapper;
    @Autowired
    private ApiOrderMapper apiOrderMapper;
    @Autowired
    private ApiOrderGoodsMapper apiOrderGoodsMapper;
    @Autowired
    private ApiProductService productService;
    @Autowired
    private ApiGoodsService apiGoodsService;
    @Autowired
    private ApiOrderShippingService apiOrderShippingService;

    public OrderVo queryObjectByOrderSn(String orderSn) {
        return this.orderDao.queryObjectByOrderSn(orderSn);
    }

    public OrderVo queryObject(Integer id) {
        return (OrderVo)this.orderDao.queryObject(id);
    }

    public List<OrderVo> queryList(Map<String, Object> map) {
        return this.orderDao.queryList(map);
    }

    public int queryTotal(Map<String, Object> map) {
        return this.orderDao.queryTotal(map);
    }

    public void save(OrderVo order) {
        this.orderDao.save(order);
    }

    public int update(OrderVo order) {
        return this.orderDao.update(order);
    }

    public void delete(Integer id) {
        this.orderDao.delete(id);
    }

    public void deleteBatch(Integer[] ids) {
        this.orderDao.deleteBatch(ids);
    }

    @Transactional
    public Map<String, Object> submit(JSONObject jsonParam, UserVo loginUser) {
        BigDecimal goodsTotalPrice;
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        Integer couponId = jsonParam.getInteger("couponId");
        String type = jsonParam.getString("type");
        String postscript = jsonParam.getString("postscript");
        AddressVo addressVo = (AddressVo)this.apiAddressMapper.queryObject(jsonParam.getInteger("addressId"));
        List<CartVo> checkedGoodsList = new ArrayList();
        if (type.equals("cart")) {
            HashMap<String, Number> param = new HashMap<String, Number>();
            param.put("user_id", loginUser.getUserId());
            param.put("session_id", 1);
            param.put("checked", 1);
            checkedGoodsList = this.apiCartMapper.queryList(param);
            if (null == checkedGoodsList) {
                resultObj.put("errno", 400);
                resultObj.put("errmsg", "\u8bf7\u9009\u62e9\u5546\u54c1");
                return resultObj;
            }
            goodsTotalPrice = new BigDecimal(0.0);
            for (CartVo cartItem : checkedGoodsList) {
                goodsTotalPrice = goodsTotalPrice.add(cartItem.getRetail_price().multiply(new BigDecimal(cartItem.getNumber())));
            }
        } else {
            BuyGoodsVo goodsVo = (BuyGoodsVo)J2CacheUtils.get((String)J2CacheUtils.SHOP_CACHE_NAME, (String)("goods" + loginUser.getUserId()));
            ProductVo productInfo = this.productService.queryObject(goodsVo.getProductId());
            goodsTotalPrice = productInfo.getRetail_price().multiply(new BigDecimal(goodsVo.getNumber()));
            CartVo cartVo = new CartVo();
            BeanUtils.copyProperties((Object)productInfo, (Object)cartVo);
            cartVo.setNumber(goodsVo.getNumber());
            cartVo.setProduct_id(goodsVo.getProductId());
            cartVo.setGoods_specifition_ids(goodsVo.getGoodsSpecifitionIds());
            checkedGoodsList.add(cartVo);
        }
        BigDecimal couponPrice = new BigDecimal(0.0);
        CouponVo couponVo = null;
        if (couponId != null && couponId != 0 && (couponVo = this.apiCouponMapper.getUserCoupon(couponId)) != null && couponVo.getCoupon_status() == 1) {
            couponPrice = couponVo.getType_money();
        }
        HashMap<Integer, BigDecimal> brandMap = new HashMap<Integer, BigDecimal>();
        GoodsVo goodsVo = null;
        for (CartVo cartVo : checkedGoodsList) {
            goodsVo = this.apiGoodsService.queryObject(cartVo.getGoods_id());
            if (brandMap.get(goodsVo.getBrand_id()) == null) {
                brandMap.put(goodsVo.getBrand_id(), cartVo.getRetail_price().multiply(new BigDecimal(cartVo.getNumber())));
                continue;
            }
            brandMap.put(goodsVo.getBrand_id(), ((BigDecimal)brandMap.get(goodsVo.getBrand_id())).add(cartVo.getRetail_price().multiply(new BigDecimal(cartVo.getNumber()))));
        }
        Integer freightPrice = 0;
        for (Integer key : brandMap.keySet()) {
            if (!(((BigDecimal)brandMap.get(key)).doubleValue() < 99.0)) continue;
            freightPrice = freightPrice + 10;
        }
        BigDecimal bigDecimal = goodsTotalPrice.add(new BigDecimal(freightPrice));
        BigDecimal actualPrice = bigDecimal.subtract(couponPrice);
        Long currentTime = System.currentTimeMillis() / 1000L;
        OrderVo orderInfo = new OrderVo();
        orderInfo.setOrder_sn(CommonUtil.generateOrderNumber());
        orderInfo.setUser_id(loginUser.getUserId());
        orderInfo.setConsignee(addressVo.getUserName());
        orderInfo.setMobile(addressVo.getTelNumber());
        orderInfo.setCountry(addressVo.getNationalCode());
        orderInfo.setProvince(addressVo.getProvinceName());
        orderInfo.setCity(addressVo.getCityName());
        orderInfo.setDistrict(addressVo.getCountyName());
        orderInfo.setAddress(addressVo.getDetailInfo());
        orderInfo.setFreight_price(freightPrice);
        orderInfo.setPostscript(postscript);
        orderInfo.setCoupon_id(couponId);
        orderInfo.setCoupon_price(couponPrice);
        orderInfo.setAdd_time(new Date());
        orderInfo.setGoods_price(goodsTotalPrice);
        orderInfo.setOrder_price(bigDecimal);
        orderInfo.setActual_price(actualPrice);
        orderInfo.setOrder_status(0);
        orderInfo.setShipping_status(0);
        orderInfo.setPay_status(0);
        orderInfo.setShipping_id(0);
        orderInfo.setShipping_fee(new BigDecimal(0));
        orderInfo.setIntegral(0);
        orderInfo.setIntegral_money(new BigDecimal(0));
        if (type.equals("cart")) {
            orderInfo.setOrder_type("1");
        } else {
            orderInfo.setOrder_type("4");
        }
        this.apiOrderMapper.save(orderInfo);
        if (null == orderInfo.getId()) {
            resultObj.put("errno", 1);
            resultObj.put("errmsg", "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25");
            return resultObj;
        }
        for (CartVo cartVo : checkedGoodsList) {
            OrderGoodsVo orderGoodsVo = new OrderGoodsVo();
            orderGoodsVo.setOrder_id(orderInfo.getId());
            orderGoodsVo.setGoods_id(cartVo.getGoods_id());
            orderGoodsVo.setGoods_sn(cartVo.getGoods_sn());
            orderGoodsVo.setProduct_id(cartVo.getProduct_id());
            orderGoodsVo.setGoods_name(cartVo.getGoods_name());
            orderGoodsVo.setList_pic_url(cartVo.getList_pic_url());
            orderGoodsVo.setMarket_price(cartVo.getMarket_price());
            orderGoodsVo.setRetail_price(cartVo.getRetail_price());
            orderGoodsVo.setNumber(cartVo.getNumber());
            orderGoodsVo.setGoods_specifition_name_value(cartVo.getGoods_specifition_name_value());
            orderGoodsVo.setGoods_specifition_ids(cartVo.getGoods_specifition_ids());
            this.apiOrderGoodsMapper.save(orderGoodsVo);
        }
        OrderShippingVo shippingVo = new OrderShippingVo();
        for (Integer key : brandMap.keySet()) {
            shippingVo = new OrderShippingVo();
            shippingVo.setOrderId(orderInfo.getId());
            shippingVo.setBrandId(key);
            shippingVo.setTotalPrice((BigDecimal)brandMap.get(key));
            if (((BigDecimal)brandMap.get(key)).doubleValue() < 99.0) {
                shippingVo.setFreightPrice(new BigDecimal(10));
                shippingVo.setTotalPrice(((BigDecimal)brandMap.get(key)).add(new BigDecimal(10)));
            } else {
                shippingVo.setFreightPrice(new BigDecimal(0));
            }
            this.apiOrderShippingService.save(shippingVo);
        }
        this.apiCartMapper.deleteByCart(loginUser.getUserId(), 1, 1);
        resultObj.put("errno", 0);
        resultObj.put("errmsg", "\u8ba2\u5355\u63d0\u4ea4\u6210\u529f");
        HashMap<String, OrderVo> hashMap = new HashMap<String, OrderVo>();
        hashMap.put("orderInfo", orderInfo);
        resultObj.put("data", hashMap);
        if (couponVo != null && couponVo.getCoupon_status() == 1) {
            couponVo.setCoupon_status(2);
            this.apiCouponMapper.updateUserCoupon(couponVo);
        }
        return resultObj;
    }
}

