/*
 * Decompiled with CFR 0.152.
 */
package com.platform.interceptor;

import com.platform.annotation.IgnoreAuth;
import com.platform.entity.TokenEntity;
import com.platform.service.TokenService;
import com.platform.utils.ApiRRException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class AuthorizationInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private TokenService tokenService;
    public static final String LOGIN_USER_KEY = "LOGIN_USER_KEY";
    public static final String LOGIN_TOKEN_KEY = "X-Nideshop-Token";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers", "x-requested-with,X-Nideshop-Token,X-URL-PATH");
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        IgnoreAuth annotation = (IgnoreAuth)((HandlerMethod)handler).getMethodAnnotation(IgnoreAuth.class);
        if (annotation != null) {
            return true;
        }
        String token = request.getHeader(LOGIN_TOKEN_KEY);
        if (StringUtils.isBlank((String)token)) {
            token = request.getParameter(LOGIN_TOKEN_KEY);
        }
        if (StringUtils.isBlank((String)token)) {
            throw new ApiRRException("\u8bf7\u5148\u767b\u5f55", 401);
        }
        TokenEntity tokenEntity = this.tokenService.queryByToken(token);
        if (tokenEntity == null || tokenEntity.getExpireTime().getTime() < System.currentTimeMillis()) {
            throw new ApiRRException("token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", 401);
        }
        request.setAttribute(LOGIN_USER_KEY, (Object)tokenEntity.getUserId());
        return true;
    }
}

