/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.alibaba.fastjson.JSONObject;
import com.platform.annotation.LoginUser;
import com.platform.entity.SmsLogVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiUserService;
import com.platform.service.SysConfigService;
import com.platform.util.ApiBaseAction;
import com.platform.utils.CharUtil;
import com.platform.utils.SmsUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f1a\u5458\u9a8c\u8bc1"})
@RestController
@RequestMapping(value={"/api/user"})
public class ApiUserController
extends ApiBaseAction {
    @Autowired
    private ApiUserService userService;
    @Autowired
    private SysConfigService sysConfigService;

    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1")
    @PostMapping(value={"smscode"})
    public Object smscode(@LoginUser UserVo loginUser) {
        String regex;
        JSONObject jsonParams = this.getJsonRequest();
        String phone = jsonParams.getString("phone");
        if (!phone.matches(regex = "^1[3-9][0-9]\\d{8}$")) {
            return this.toResponsFail("\u624b\u673a\u53f7\u4e0d\u7b26\u5408\u683c\u5f0f");
        }
        SmsLogVo smsLogVo = this.userService.querySmsCodeByUserId(loginUser.getUserId());
        if (null != smsLogVo && System.currentTimeMillis() / 1000L - smsLogVo.getLog_date() < 60L) {
            return this.toResponsFail("\u77ed\u4fe1\u5df2\u53d1\u9001");
        }
        String sms_code = CharUtil.getRandomNum((Integer)4);
        String sms_txt = "\u9a8c\u8bc1\u7801\uff1a" + sms_code + "\uff0c\u611f\u8c22\u60a8\u4f7f\u7528\u534e\u53d1\u5546\u90fdVR\uff0c\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\u4ee5\u5b8c\u6210\u8eab\u4efd\u9a8c\u8bc1\uff0c\u6709\u6548\u671f5\u5206\u949f\u3002\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u6b64\u6d88\u606f\u3002";
        boolean falg = false;
        int templateId = 23;
        try {
            falg = SmsUtil.sendAliSms((String)phone, (String)("{\"code\":\"" + sms_code + "\"}"), (String)"SMS_184816840");
        }
        catch (Exception e) {
            return this.toResponsFail("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        if (falg) {
            smsLogVo = new SmsLogVo();
            smsLogVo.setLog_date(System.currentTimeMillis() / 1000L);
            smsLogVo.setUser_id(loginUser.getUserId());
            smsLogVo.setPhone(phone);
            smsLogVo.setSms_code(Integer.parseInt(sms_code));
            smsLogVo.setSms_text(sms_txt);
            this.userService.saveSmsCodeLog(smsLogVo);
            return this.toResponsSuccess("\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
        }
        return this.toResponsFail("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u4f1a\u5458\u7b49\u7ea7")
    @PostMapping(value={"getUserLevel"})
    public Object getUserLevel(@LoginUser UserVo loginUser) {
        String userLevel = this.userService.getUserLevel(loginUser);
        return this.toResponsSuccess(userLevel);
    }

    @ApiOperation(value="\u7ed1\u5b9a\u624b\u673a")
    @PostMapping(value={"bindMobile"})
    public Object bindMobile(@LoginUser UserVo loginUser, @RequestParam(value="mobileCode", defaultValue="1") Integer mobile_code, @RequestParam(value="mobile", defaultValue="10") String mobile) {
        SmsLogVo smsLogVo = this.userService.querySmsCodeByUserId(loginUser.getUserId());
        if (mobile_code.intValue() != smsLogVo.getSms_code()) {
            return this.toResponsFail("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        UserVo userVo = this.userService.queryObject(loginUser.getUserId());
        userVo.setMobile(mobile);
        this.userService.update(userVo);
        return this.toResponsSuccess("\u624b\u673a\u7ed1\u5b9a\u6210\u529f");
    }
}

