/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.platform.annotation.IgnoreAuth;
import com.platform.annotation.LoginUser;
import com.platform.entity.TopicVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiTopicService;
import com.platform.util.ApiBaseAction;
import com.platform.util.ApiPageUtils;
import com.platform.utils.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/topic"})
public class ApiTopicController
extends ApiBaseAction {
    @Autowired
    private ApiTopicService topicService;

    @IgnoreAuth
    @PostMapping(value={"list"})
    public Object list(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("page", page);
        param.put("limit", size);
        param.put("sidx", "id");
        param.put("order", "desc");
        param.put("fields", "id, title, price_info, scene_pic_url,subtitle");
        Query query = new Query(param);
        List<TopicVo> topicEntities = this.topicService.queryList((Map<String, Object>)query);
        int total = this.topicService.queryTotal((Map<String, Object>)query);
        ApiPageUtils pageUtil = new ApiPageUtils(topicEntities, total, query.getLimit(), query.getPage());
        return this.toResponsSuccess(pageUtil);
    }

    @IgnoreAuth
    @PostMapping(value={"detail"})
    public Object detail(@LoginUser UserVo loginUser, Integer id) {
        TopicVo topicEntity = this.topicService.queryObject(id);
        return this.toResponsSuccess(topicEntity);
    }

    @IgnoreAuth
    @PostMapping(value={"related"})
    public Object related(@LoginUser UserVo loginUser, Integer id) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("limit", 4);
        List<TopicVo> topicEntities = this.topicService.queryList(param);
        return this.toResponsSuccess(topicEntities);
    }
}

