/*
 * Decompiled with CFR 0.152.
 */
package com.platform.api;

import com.platform.annotation.IgnoreAuth;
import com.platform.annotation.LoginUser;
import com.platform.entity.KeywordsVo;
import com.platform.entity.SearchHistoryVo;
import com.platform.entity.UserVo;
import com.platform.service.ApiKeywordsService;
import com.platform.service.ApiSearchHistoryService;
import com.platform.util.ApiBaseAction;
import com.platform.utils.Query;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u641c\u7d22"})
@RestController
@RequestMapping(value={"/api/search"})
public class ApiSearchController
extends ApiBaseAction {
    @Autowired
    private ApiKeywordsService keywordsService;
    @Autowired
    private ApiSearchHistoryService searchHistoryService;

    @ApiOperation(value="\u641c\u7d22\u5546\u54c1\u5217\u8868")
    @IgnoreAuth
    @PostMapping(value={"index"})
    public Object index(@LoginUser UserVo loginUser) {
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("is_default", 1);
        param.put("page", 1);
        param.put("limit", 1);
        param.put("sidx", "id");
        param.put("order", "asc");
        List<KeywordsVo> keywordsEntityList = this.keywordsService.queryList(param);
        KeywordsVo defaultKeyword = null != keywordsEntityList && keywordsEntityList.size() > 0 ? keywordsEntityList.get(0) : null;
        param = new HashMap();
        param.put("fields", "distinct keyword,is_hot");
        param.put("page", 1);
        param.put("limit", 10);
        param.put("sidx", "id");
        param.put("order", "asc");
        Query query = new Query(param);
        List<Map> hotKeywordList = this.keywordsService.hotKeywordList((Map<String, Object>)query);
        String[] historyKeywordList = null;
        if (loginUser != null) {
            param = new HashMap();
            param.put("user_id", loginUser.getUserId());
            param.put("fields", "distinct keyword");
            param.put("page", 1);
            param.put("limit", 10);
            param.put("sidx", "id");
            param.put("order", "asc");
            List<SearchHistoryVo> historyVoList = this.searchHistoryService.queryList(param);
            historyKeywordList = new String[historyVoList.size()];
            if (null != historyVoList) {
                int i = 0;
                for (SearchHistoryVo historyVo : historyVoList) {
                    historyKeywordList[i] = historyVo.getKeyword();
                    ++i;
                }
            }
        }
        resultObj.put("defaultKeyword", defaultKeyword);
        resultObj.put("historyKeywordList", historyKeywordList);
        resultObj.put("hotKeywordList", hotKeywordList);
        return this.toResponsSuccess(resultObj);
    }

    @ApiOperation(value="\u641c\u7d22\u5546\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57", paramType="path", required=true)})
    @IgnoreAuth
    @PostMapping(value={"helper"})
    public Object helper(@LoginUser UserVo loginUser, String keyword) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("fields", "distinct keyword");
        param.put("keyword", keyword);
        param.put("limit", 10);
        param.put("offset", 0);
        List<KeywordsVo> keywords = this.keywordsService.queryList(param);
        String[] keys = new String[keywords.size()];
        if (null != keywords) {
            int i = 0;
            for (KeywordsVo keywordsVo : keywords) {
                keys[i] = keywordsVo.getKeyword();
                ++i;
            }
        }
        return this.toResponsSuccess(keys);
    }

    @PostMapping(value={"clearhistory"})
    public Object clearhistory(@LoginUser UserVo loginUser) {
        this.searchHistoryService.deleteByUserId(loginUser.getUserId());
        return this.toResponsSuccess("");
    }
}

